/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.drawable.IDrawable;

public class HighResolutionDrawable
implements IDrawable {
    private final IDrawable drawable;
    private final int scale;

    public HighResolutionDrawable(IDrawable drawable, int scale) {
        int width = drawable.getWidth();
        int height = drawable.getHeight();
        Preconditions.checkArgument((width % scale == 0 ? 1 : 0) != 0, (Object)String.format("drawable width %s must be divisible by the scale %s", width, scale));
        Preconditions.checkArgument((height % scale == 0 ? 1 : 0) != 0, (Object)String.format("drawable height %s must be divisible by the scale %s", height, scale));
        this.drawable = drawable;
        this.scale = scale;
    }

    @Override
    public int getWidth() {
        return this.drawable.getWidth() / this.scale;
    }

    @Override
    public int getHeight() {
        return this.drawable.getHeight() / this.scale;
    }

    @Override
    public void draw(PoseStack poseStack, int xOffset, int yOffset) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)xOffset, (double)yOffset, 0.0);
        poseStack.m_85841_(1.0f / (float)this.scale, 1.0f / (float)this.scale, 1.0f);
        this.drawable.draw(poseStack);
        poseStack.m_85849_();
    }

    @Override
    public void draw(PoseStack poseStack) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f / (float)this.scale, 1.0f / (float)this.scale, 1.0f);
        this.drawable.draw(poseStack);
        poseStack.m_85849_();
    }
}

